#ifndef ACCELLENT_CGS_H
#define ACCELLENT_CGS_H

extern "C" {
typedef int CGSConnectionID;
typedef int CGSSurfaceID;
struct CGSObj { };
struct CGSBoolean : public CGSObj { };
struct CGSString : public CGSObj { };

CGSConnectionID _CGSDefaultConnection();

CGSConnectionID CGSMainConnectionID();
OSErr CGSGetWindowBounds( CGSConnectionID conn, int windowID, CGRect * rect );

void CGSAddSurface( CGSConnectionID conn, int windowID, CGSSurfaceID * surfaceID );
void CGSOrderSurface( CGSConnectionID conn, int windowID, CGSSurfaceID surfaceID, int unk1, int unk2 );
void CGSSetSurfaceBounds( CGSConnectionID conn, int windowID, CGSSurfaceID surfaceID, CGRect rect );

CGSBoolean * CGSCreateBoolean( bool val );
CGSString * CGSUniqueCString( char * str );
void CGSReleaseObj( CGSObj * obj );

void CGSSetWindowProperty( CGSConnectionID conn, int windowID, CGSString * key, CGSObj * value );

}

#endif
